####################
##############
### AESO ILF Write Workbook Main Script
#########################

import wx
import os
import sys
from datetime import datetime
from datetime import timedelta as td


	
class MyFrame(wx.Frame):
	def __init__(self, parent, id, title):
		wx.Frame.__init__(self, parent, id, title, (-1, -1), wx.Size(400, 700))
		hbox = wx.BoxSizer(wx.HORIZONTAL)
		
		
		baseDir = r"C:\Users\sdr\Desktop\06 Apr 2019\Test Folder"
		baseDirTemplate = r"C:\Users\sdr\Desktop\06 Apr 2019\Test Folder\Template"
		templateName = r"2019 LF Results Template.xlsx"
		# self.sourceDir = os.path.join(os.getcwd(), '2017 LF Results')
		self.sourceDir = baseDir
		# self.state1ErrorLogDir = os.path.join(os.getcwd(), '2017 LF Results')
		self.state1ErrorLogDir = baseDir
		
		self.templateFile = os.path.join(baseDirTemplate, templateName)
		self.monthRange = "May-Aug"
		self.Year = 2019
		########## PANEL 1 ##############
		panel1 = wx.Panel(self, -1, style=wx.SIMPLE_BORDER)
		hbox_p1 = wx.BoxSizer(wx.VERTICAL)
		
		box1 = wx.BoxSizer(wx.VERTICAL)
		box_action = wx.BoxSizer(wx.VERTICAL)
		hbox_p1.Add( box1, 1, wx.EXPAND, 5 )
		hbox_p1.Add( box_action, 1, wx.EXPAND, 5 )
		
		self.inputdir_button = wx.Button(panel1, -1, 'Browse')
		self.errorlogdir_button = wx.Button(panel1, -1, 'Browse')
		self.WorkBookTemplate_button = wx.Button(panel1, -1, 'LF Results Template', size=(150,30))
		
		
		months = ["Jan-Apr", "May-Aug", "Sep-Dec"]
		self.combobox_month1 = wx.ComboBox(panel1, id = -1, value = "Select Range of Months", size=(200, -1), choices=months, style=wx.CB_DROPDOWN, name="ComboBoxMonth")
		
		self.WB_maxRow = 135
		
		self.m_staticTextTitle = wx.StaticText( panel1, wx.ID_ANY, u"AESO ILF (Write Workbook)", wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_staticTextTitle.Wrap( -1 )
		self.m_staticTextTitle.SetFont( wx.Font( 16, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, False, wx.EmptyString ) )
		self.m_staticText_inputdir2 = wx.StaticText( panel1, wx.ID_ANY, u"", wx.DefaultPosition, wx.DefaultSize, 0 )
		
		self.m_staticText_inputdir3 = wx.StaticText( panel1, wx.ID_ANY, u"State-2 Results Directory Path", wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_staticText_errorlogdir = wx.StaticText( panel1, wx.ID_ANY, u"State-1 Error Log Files Directory Path", wx.DefaultPosition, wx.DefaultSize, 0 )
		# self.m_staticText_MaxRow = wx.StaticText( panel1, wx.ID_ANY, u"Enter Max Number of Excel Rows in Template", wx.DefaultPosition, wx.DefaultSize, 0 )
		
		
		self.m_staticText_inputdir4 = wx.StaticText( panel1, wx.ID_ANY, u"", wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_staticText_inputdir5 = wx.StaticText( panel1, wx.ID_ANY, u"", wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_staticText_inputdir6 = wx.StaticText( panel1, wx.ID_ANY, u"", wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_textCtr_inputdir = wx.TextCtrl( panel1, wx.ID_ANY, wx.EmptyString, wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_textCtr_errorlogdir = wx.TextCtrl( panel1, wx.ID_ANY, wx.EmptyString, wx.DefaultPosition, wx.DefaultSize, 0 )
		# self.m_textCtr_MaxRow = wx.TextCtrl( panel1, wx.ID_ANY, wx.EmptyString, wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_textCtr_MaxRow = wx.TextCtrl( panel1, wx.ID_ANY, 'Enter Max Row Number (%s Default)' %self.WB_maxRow, wx.DefaultPosition, (300,25), 0 )
		
		years = range(2006,2050)
		yrs = []
		for yr in years:
			yrs.append(str(yr))
		self.combobox_year = wx.ComboBox(panel1, id = -1, value = "Select Year", size=(150, -1), choices=yrs, style=wx.CB_DROPDOWN, name="ComboBoxYear")
		
		
		box1.Add(self.m_staticTextTitle, 0,  wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.m_staticText_inputdir2, 0,  wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.m_staticText_inputdir3, 0,  wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.m_textCtr_inputdir, 0,  wx.ALIGN_CENTER|wx.EXPAND|wx.ALL, 5)
		box1.Add(self.inputdir_button, 0,  wx.ALIGN_CENTER|wx.ALL, 5)
		
		box1.Add(self.m_staticText_errorlogdir, 0,  wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.m_textCtr_errorlogdir, 0,  wx.ALIGN_CENTER|wx.EXPAND|wx.ALL, 5)
		box1.Add(self.errorlogdir_button, 0,  wx.ALIGN_CENTER|wx.ALL, 5)
		
		box1.Add(self.combobox_month1,0, wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.combobox_year,0, wx.ALIGN_CENTER|wx.ALL, 5)
		
		box1.Add(self.m_staticText_inputdir4, 0,  wx.ALL, 5)

		box1.Add(self.WorkBookTemplate_button,0, wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.m_textCtr_MaxRow,0, wx.ALIGN_CENTER|wx.ALL, 5)
		
		# box1.Add(self.m_staticText_MaxRow,0, wx.ALIGN_CENTER|wx.ALL, 5)
		
		
		# box1.Add(self.s1logs_button,0, wx.ALIGN_CENTER|wx.ALL, 5)
		self.writeWorkbook_button = wx.Button(panel1, -1, 'Generate Workbook', size=(150,30))
		box1.Add(self.writeWorkbook_button,0, wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.m_staticText_inputdir5, 0,  wx.ALL, 5)
		box1.Add(self.m_staticText_inputdir6, 0,  wx.ALL, 5)
		
		self.exitButton = wx.Button(panel1, -1, 'Exit', size=(150,30))
		box1.Add(self.exitButton,0, wx.ALIGN_CENTER|wx.ALL, 5)
		
		
		panel1.SetSizer(hbox_p1)
		
		
		############### EVENT DESCRIPTIONS ##############
		self.Bind (wx.EVT_BUTTON, self.OnInputDir, self.inputdir_button)
		self.Bind (wx.EVT_BUTTON, self.OnErrorLogDir, self.errorlogdir_button)
		# self.Bind (wx.EVT_BUTTON, self.OnSelectWorkbookTemplate, self.s1cases_button)
		self.Bind (wx.EVT_BUTTON, self.OnSelectWorkbookTemplate, self.WorkBookTemplate_button)
		
		self.Bind (wx.EVT_BUTTON, self.onStartWrite, self.writeWorkbook_button)
		self.Bind (wx.EVT_BUTTON, self.onExit, self.exitButton)
		self.Bind (wx.EVT_COMBOBOX, self.onSelectMonth1, self.combobox_month1)
		self.Bind (wx.EVT_COMBOBOX, self.onSelectYear1, self.combobox_year)
		
		
		################ Add Panel 1, to hbox
		hbox.Add(panel1, 1, wx.EXPAND | wx.ALL, 0)

		
		############## Frame Set Sizer #########
		# self.SetSize((400, 120))
		self.SetSizer(hbox)
		self.Centre()
		
		# self.onStartWrite(None)
		# self.onExit(None)
		
	
	def onExit(self, event):
		# self.Hide()
		self.Destroy()
		# import ilfmain_lossInfo
		# self.secondWindow = ilfmain_lossInfo.main()
		# self.Bind(wx.EVT_CLOSE, self.on_close, self.secondWindow)

	def OnInputDir(self, event):
		wildcard = ""
		dlg = wx.DirDialog(None, "Browse for State-2 Results directory",style=wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
		if dlg.ShowModal() == wx.ID_OK:
			# print dlg.GetPath()
			self.sourceDir =  str(dlg.GetPath())
			self.m_textCtr_inputdir.SetValue(str(self.sourceDir))
		print "Selected Input Folder : "
		print self.sourceDir	
		dlg.Destroy()
	
	def OnErrorLogDir(self, event):
		wildcard = ""
		dlg = wx.DirDialog(None, "Browse for State-1 Error Log Files directory",style=wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
		if dlg.ShowModal() == wx.ID_OK:
			# print dlg.GetPath()
			self.state1ErrorLogDir =  str(dlg.GetPath())
			self.m_textCtr_errorlogdir.SetValue(str(self.state1ErrorLogDir))
		print "Selected State-1 Error Log Folder : "
		print self.state1ErrorLogDir	
		dlg.Destroy()
	
	def onStartWrite(self, event):
		
		try:
			self.WB_maxRow = int(self.m_textCtr_MaxRow.GetValue())
			print "Max Number of Rows : ", self.WB_maxRow
		except:
			print "Max Number of Rows : ", self.WB_maxRow, " Default"
		import WriteWorkbook
		WriteWorkbook.ilf_main(self.sourceDir, self.templateFile, self.state1ErrorLogDir, self.monthRange, self.Year, self.WB_maxRow)

		
	def OnSelectWorkbookTemplate(self, event):
		wildcard=""
		self.templateFile = ""
		# dlg = wx.FileDialog(self, "Choose a file", os.getcwd(), "", wildcard, wx.FD_OPEN)
		dlg = wx.FileDialog(self, "Choose Workbook Template", os.getcwd(), "", "*.xlsx", wx.FD_OPEN)
		# dlg = wx.FileDialog(self, "Choose a file", "", "", "*.*", wx.FD_MULTIPLE)
		if dlg.ShowModal() == wx.ID_OK:
			# files =  dlg.GetPaths()
			self.templateFile =  dlg.GetPath()
			print self.templateFile
			# for file in files:
				# file = str(file)
				# print file
				# self.caseFiles.append(file)
		dlg.Destroy()
	
	def onSelectMonth1(self, event):
		# self.MM = event.GetValue()
		self.monthRange = self.combobox_month1.GetValue()
	
	def onSelectYear1(self, event):
		# self.MM = event.GetValue()
		self.Year = int(self.combobox_year.GetValue())

class MyApp(wx.App):
    def OnInit(self):
        frame = MyFrame(None, -1, 'AESO ILF - State 2')
        frame.Show(True)
        return True

app = MyApp(0)
app.MainLoop()
